define(['angular', 'app', 'formatter'], function (angular, app) {
	'use strict';

    app.controller('HealthMoodNotificationStatusController', function ($scope, $q, $state, 
        $stateParams, HealthMoodRemindersService, HealthMoodConstants) {

        var detailsReady = $q.defer();
        
        $scope.sectionTitle = HealthMoodConstants[$stateParams.section].name;

		HealthMoodRemindersService.init($stateParams.section);
		HealthMoodRemindersService.getReminder().then(function (response) {
            $scope.details = angular.copy(response);
            detailsReady.resolve();
        });

        $scope.section = $stateParams.section;

        $scope.entryForm = {
            service: HealthMoodRemindersService,
            callbacks: {
                common: function () {
                    $state.go($state.current.data.backState, $stateParams);
                }
            },
            allowedActions: {
                save: true,
                cancel: true
            }
        };

        $scope.$watch('details.notificationStatus', function (status) {
            if (status !== "On" && $scope.details) {
                $scope.details.eventDate = "";
                $scope.details.frequency = "";
                $scope.details.times = [{value: ""}];
                $scope.details.notificationTypes = [];
            }
        });
    });
});